//	DAC.cpp 
//	written by Dr. Sam Green, W0PCE 
//	for the Fully Automated DDS Sweep Generator Measurement System 
/*
	This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
//	This program writes a constant value or a repeititive sawtooth waveform to the D to A converter 
//	Enter parameters in integer millivolts between -2500 and +2500  
//
//  MAXIM MX7543 serial D to A Converter driver uses control port of PC parallel port
//  With hardware set up for bipolar operation,
//  0x000 gives (2048/2048) x (-Vref)
//  0x800 gives 0 volts
//  0xfff gives (2047/2048) x (+Vref)

//  With Vref set by LM385-25 to 2.5 volts, range is from -2.5V to +2.499V 
//		or a resolution of 1.22 mV 

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <windows.h>

void write12databits2c0 (int dacword) ;
void gotoxy (int x, int y) ;
void delay (int time) ;
void delaym (long msecs) ;


int base	= 0x378,	// parallel port register addresses
	status	= base+1,
	control	= base+2,
	dacstart = 0x000,	// default -Vref start
	dacend   = 0xfff, 	// default Vref*2047/2048 end
	dacword = dacstart,
	numberofsteps = 0x4096,	
	stepcount,
	dwell = 0, 
	sweep = 0;			// default constant output - sweeps if sweep = 1 

const double 
	Vref = 2.5919,		// for LM385-25 
	offset = 0.010 ;	// software correction of op-amp offset instead of trimpot 

void main(int argc, char *argv[]) {
	float dacfloat;
	system("CLS");
	dacword = dacstart;  

	if (argc < 2){	printf("Usage: %s Vstart [Vend] [#steps] [dwell]\n\nConstant output for single argument\n\n", argv[0]);
					puts("Sweeps for two arguments with Vstart less than Vend\n\nand both between -2470 to +2470 mV\n");
					puts("in integer mV with no decimal \n\nand dwell per step in ms\n"); exit(1);}
	if (argc>1) {dacstart = atoi(argv[1]);	// enter dacword start in integer mV 
		if (dacstart < -2470) {dacstart = -2470; puts("minimum Vsource is -2470 mV!");}
		if (dacstart > +2470) {dacstart = +2470; puts("maximum Vsource is +2470 mV!");}
		dacfloat=float(dacstart);
		dacfloat = 1 - offset + dacfloat/(Vref*1000); 
		dacstart = dacfloat * 2048; 
		}
	if (argc>2) {dacend   = atoi(argv[2]);	// enter dacword end in integer mV
		sweep = 1 ;
		if (dacend < -2470) {dacend = -2470; puts("minimum Vsource is -2470 mV!");}
		if (dacend > +2470) {dacend = +2470; puts("maximum Vsource is +2470 mV!");}
		dacfloat=float(dacend);
		dacfloat = 1 - offset + dacfloat/(Vref*1000); 
		dacend = dacfloat * 2048; 
		} 
		if (dacend < dacstart) {puts("Vend must be higher than Vstart!");_exit(1);}
		if (dacend>0xfff) exit(1); if (dacstart<0) exit(1);
	if (argc>3) numberofsteps = atoi(argv[3]); 
	if (argc>4) dwell = atoi(argv[4]); 

	stepcount = (dacend-dacstart)/numberofsteps ;
	if (stepcount == 0) stepcount =1; 

	if (sweep == 0) {

	write12databits2c0 (dacstart) ;
	gotoxy(3,9);printf("\tConstant Value = %1.3f", Vref*(-1 + float(dacword)/2048));
	}

	if (sweep == 1) {
		gotoxy(3,4);printf("\tStart \t\t\t= %1.3f  ", Vref*(-1 + offset + float(dacstart)/2048)); 
		gotoxy(3,5);printf("\tEnd \t\t\t= %1.3f  "  , Vref*(-1 + offset + float(dacend)  /2048));
		gotoxy(3,6);printf("\tNumber of Steps\t\t= %d   ",numberofsteps);
		gotoxy(3,7);printf("\tCount Increment\t\t= %d    \n", stepcount);	
	
		while(1){						
		_outp(control, 8);_outp(control, 0);// pulse  pin 17 high & low (optional o'scope trigger)  
		for(dacword = dacstart; dacword < dacend; dacword += stepcount) {
			write12databits2c0 (dacword) ;
			gotoxy(3,9);printf("\tInstantaneous Value = %1.3f", Vref*(-1 + float(dacword)/2048));
			delaym (dwell) ;
} }	}	} 

void write12databits2c0 (int dacword) { // with clock to c1 & transfer update strobe to c2 
	int dacvar, i, writebit, mask=0x1000;

	dacvar = ~dacword ;					// bitwise invert to write data to inverted C0 
	for(i=1; i<13; i++) {           
		mask >>= 1 ; writebit = dacvar & mask ; if (writebit!=0) writebit = 1; // reverses dacvar 
		_outp(base+2, 4 + writebit);	// write bit & keep both load (4) and clear (8) inactive
		_outp(base+2, 6 + writebit);	// writeclock low through inverted C1 & keep both load and clear inactive
		_outp(base+2, 4 + writebit);	// writeclock high through inverted C1 & keep both load and clear inactive
		}
	_outp(base+2, 0);					//  update stobe pulse low noninverted C2
	_outp(base+2, 4);					//  update stobe pulse high  
}

void gotoxy (int x, int y){				// place cursor 
	HANDLE hdl;
	COORD coords;
	hdl = GetStdHandle(STD_OUTPUT_HANDLE);
	coords.X=x-1;
	coords.Y=y-1;
	SetConsoleCursorPosition(hdl,coords);
}

void delay (int time){ // short delay in fractions of a microsecond
	int i;
	for (i=0; i<time; i++) ;
}
	
void delaym (long msecs) {  // long delay in milliseconds
	clock_t now = clock();  // get current time
	clock_t then = now + CLOCKS_PER_SEC * (long)msecs/1000 ;
	while (now<then) now=clock() ;
}
